(function(exports) {
    
exports.load_script = function(src) {
	return new Promise(function(resolve, reject) {
		let script = document.createElement('script')
		script.src = src

		script.onload = () => resolve(script)
		script.onerror = () => reject(new Error(`Ошибка загрузки скрипта ${src}`))

		document.head.append(script)
	})
}

exports.response_ready = function(response_text) {
	//console.log(response_text)
	let values = exports.get_response_values_from_text(response_text)
	return new Promise(function(resolve, reject) {
		resolve(values);
	})
}

exports.get_response_values_from_text = function(text) {
	let response_values = []
	let responseLines = text.split('\n')
	let responseLine = responseLines[0]
	response_values = responseLine.split('&#&')
	response_values.pop()
	//console.log('response_values: ' + response_values.length)

	return response_values
}

})(this.utils = {});